<?php

/**
 * ECSHOP SQLִࡣڵø෽֮ǰοӦ˵
 *
 * ============================================================================
 * Ȩ 2005-2008 ϺƼ޹˾Ȩ
 * վַ: http://www.ecshop.com
 * ----------------------------------------------------------------------------
 * ⲻһֻڲҵĿĵǰ¶Գ޸ĺ
 * ʹãԳκʽκĿĵٷ
 * ============================================================================
 * $Author: testyang $
 * $Id: cls_sql_executor.php 15013 2008-10-23 09:31:42Z testyang $
 */

if (!defined('IN_ECS'))
{
    die('Hacking attempt');
}

class sql_executor
{
    /**
     * ¼ִйϢ
     *
     * @access  public
     * @var     string       $error
     */
    var $error = '';

    /**
     * 洢ԵĴţЩ󲻻¼$errorУ
     * Ȼ¼ڴ־ļС
     *
     * @access  private
     * @var     array       $ignored_errors
     */
    var $ignored_errors = array();

    /**
     * MySQL
     *
     * @access  private
     * @var     object      $db
     */
    var $db = '';

    /**
     * ݿַ
     *
     * @access   private
     * @var      string     $charset
     */
    var $db_charset = '';

    /**
     * 滻ǰǰ׺
     *
     * @access  private
     * @var     string      $source_prefix
     */
    var $source_prefix = '';

    /**
     * 滻ǰ׺
     *
     * @access  private
     * @var     string      $target_prefix
     */
    var $target_prefix = '';

    /**
     * ʱ򽫰־¼ڸָļ
     *
     * @access  private
     * @var     string       $log_path
     */
    var $log_path = '';

    /**
     * ѡ󣬳򽫽ܻزѯʹظбҲݿĲѯͻ
     * ͷ֮ͨѶʱǷǳбҪģΪп䷢жϡõ˴
     * ʽѡ󽫷ǳķѷԴ
     *
     * @access  private
     * @var     boolean      $auto_match
     */
    var $auto_match = false;

    /**
     * ¼ǰִеSQLļ
     *
     * @access  private
     * @var     string       $current_file
     */
    var $current_file = 'Not a file, but a string.';

    /**
     * 캯
     *
     * @access  public
     * @param   mysql       $db             mysql
     * @param   string      $charset        ַ
     * @param   string      $sprefix        滻ǰǰ׺
     * @param   string      $tprefix        滻ǰ׺
     * @param   string      $log_path       ־·
     * @param   boolean     $auto_match     Ƿܻѯ
     * @param   array       $ignored_errors ԵĴ
     * @return  void
     */
    function __construct($db, $charset = 'gbk', $sprefix = 'ecs_', $tprefix = 'ecs_', $log_path = '', $auto_match = false, $ignored_errors = array())
    {
        $this->sql_executor($db, $charset, $sprefix, $tprefix, $log_path, $auto_match, $ignored_errors);
    }

    /**
     * 캯
     *
     * @access  public
     * @param   mysql       $db             mysql
     * @param   string      $charset        ַ
     * @param   string      $sprefix        滻ǰǰ׺
     * @param   string      $tprefix        滻ǰ׺
     * @param   string      $log_path       ־·
     * @param   boolean     $auto_match     Ƿܻѯ
     * @param   array       $ignored_errors ԵĴ
     * @return  void
     */
    function sql_executor($db, $charset = 'gbk', $sprefix = 'ecs_', $tprefix = 'ecs_', $log_path = '', $auto_match = false, $ignored_errors = array())
    {
        $this->db = $db;
        $this->db_charset = $charset;
        $this->source_prefix = $sprefix;
        $this->target_prefix = $tprefix;
        $this->log_path = $log_path;
        $this->auto_match = $auto_match;
        $this->ignored_errors = $ignored_errors;
    }

    /**
     * ִSQLļеSQL
     *
     * @access  public
     * @param   array       $sql_files     ļ·ɵһά
     * @return  boolean     ִгɹtrueʧܷfalse
     */
    function run_all($sql_files)
    {
        /* 飬ֱӷ */
        if (!is_array($sql_files))
        {
            return false;
        }

        foreach ($sql_files AS $sql_file)
        {
            $query_items = $this->parse_sql_file($sql_file);

            /* ʧܣ */
            if (!$query_items)
            {
                continue;
            }

            foreach ($query_items AS $query_item)
            {
                /* ѯΪգ */
                if (!$query_item)
                {
                    continue;
                }

                if (!$this->query($query_item))
                {
                    return false;
                }
            }
        }

        return true;
    }

    /**
     * ÷ɢĲѯ
     *
     * @access  public
     * @param   string      $file_path      ļľ·
     * @return  mixed       ɹطɢĲѯ飬ʧܷfalse
     */
    function parse_sql_file($file_path)
    {
        /* SQLļ򷵻false */
        if (!file_exists($file_path))
        {
            return false;
        }

        /* ¼ǰеSQLļ */
        $this->current_file = $file_path;

        /* ȡSQLļ */
        $sql = implode('', file($file_path));

        /* ɾSQLעִͣеreplaceԲҪм⡣ͬ */
        $sql = $this->remove_comment($sql);

        /* ɾSQLβĿհ׷ */
        $sql = trim($sql);

        /* SQLļûвѯ򷵻false */
        if (!$sql)
        {
            return false;
        }

        /* 滻ǰ׺ */
        $sql = $this->replace_prefix($sql);

        /* ѯ */
        $sql = str_replace("\r", '', $sql);
        $query_items = explode(";\n", $sql);

        return $query_items;
    }

    /**
     * ִĳһѯ
     *
     * @access  public
     * @param   string      $query_item      ѯ
     * @return  boolean     ɹtrueʧܷfalse
     */
    function query($query_item)
    {
        /* ɾѯβĿհ׷ */
        $query_item = trim($query_item);

        /* ѯΪ򷵻false */
        if (!$query_item)
        {
            return false;
        }

        /*  */
        if (preg_match('/^\s*CREATE\s+TABLE\s*/i', $query_item))
        {
            if (!$this->create_table($query_item))
            {
                return false;
            }
        }
        /* ALTER TABLE䣬ʱ򽫶ԱĽṹ޸ */
        elseif ($this->auto_match && preg_match('/^\s*ALTER\s+TABLE\s*/i', $query_item))
        {
            if (!$this->alter_table($query_item))
            {
                return false;
            }
        }
        /* ޸Ĳӡ¡ɾ */
        else
        {
            if (!$this->do_other($query_item))
            {
                return false;
            }
        }

        return true;
    }

    /**
     * SQLѯеע͡÷ֻSQLļжռһлһЩע͡
     *
     * @access  public
     * @param   string      $sql        SQLѯ
     * @return  string      ѹ˵ע͵SQLѯ
     */
    function remove_comment($sql)
    {
        /* ɾSQLעͣעͲƥ任з */
        $sql = preg_replace('/^\s*(?:--|#).*/m', '', $sql);

        /* ɾSQLעͣƥ任зΪ̰ƥ */
        //$sql = preg_replace('/^\s*\/\*(?:.|\n)*\*\//m', '', $sql);
        $sql = preg_replace('/^\s*\/\*.*?\*\//ms', '', $sql);

        return $sql;
    }

    /**
     * 滻ѯݱǰ׺÷ֻвѯЧCREATE TABLE,
     * DROP TABLE, ALTER TABLE, UPDATE, REPLACE INTO, INSERT INTO
     *
     * @access  public
     * @param   string      $sql        SQLѯ
     * @return  string      滻ǰ׺SQLѯ
     */
    function replace_prefix($sql)
    {
        $keywords = 'CREATE\s+TABLE(?:\s+IF\s+NOT\s+EXISTS)?|'
                  . 'DROP\s+TABLE(?:\s+IF\s+EXISTS)?|'
                  . 'ALTER\s+TABLE|'
                  . 'UPDATE|'
                  . 'REPLACE\s+INTO|'
                  . 'INSERT\s+INTO';

        $pattern = '/(' . $keywords . ')(\s*)`?' . $this->source_prefix . '(\w+)`?(\s*)/i';
        $replacement = '\1\2`' . $this->target_prefix . '\3`\4';
        $sql = preg_replace($pattern, $replacement, $sql);

        $pattern = '/(UPDATE.*?WHERE)(\s*)`?' . $this->source_prefix . '(\w+)`?(\s*\.)/i';
        $replacement = '\1\2`' . $this->target_prefix . '\3`\4';
        $sql = preg_replace($pattern, $replacement, $sql);

        return $sql;
    }

    /**
     * ȡ֡÷ֻвѯЧCREATE TABLE,
     * DROP TABLE, ALTER TABLE, UPDATE, REPLACE INTO, INSERT INTO
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @param   string      $query_type     ѯ
     * @return  mixed       ɹر֣ʧܷfalse
     */
    function get_table_name($query_item, $query_type = '')
    {
        $pattern = '';
        $matches = array();
        $table_name = '';

        /* ûָ$query_typeԶȡ */
        if (!$query_type && preg_match('/^\s*(\w+)/', $query_item, $matches))
        {
            $query_type = $matches[1];
        }

        /* ȡӦʽ */
        $query_type = strtoupper($query_type);
        switch ($query_type)
        {
        case 'ALTER' :
            $pattern = '/^\s*ALTER\s+TABLE\s*`?(\w+)/i';
            break;
        case 'CREATE' :
            $pattern = '/^\s*CREATE\s+TABLE(?:\s+IF\s+NOT\s+EXISTS)?\s*`?(\w+)/i';
            break;
        case 'DROP' :
            $pattern = '/^\s*DROP\s+TABLE(?:\s+IF\s+EXISTS)?\s*`?(\w+)/i';
            break;
        case 'INSERT' :
            $pattern = '/^\s*INSERT\s+INTO\s*`?(\w+)/i';
            break;
        case 'REPLACE' :
            $pattern = '/^\s*REPLACE\s+INTO\s*`?(\w+)/i';
            break;
        case 'UPDATE' :
            $pattern = '/^\s*UPDATE\s*`?(\w+)/i';
            break;
        default :
            return false;
        }

        if (!preg_match($pattern, $query_item, $matches))
        {
            return false;
        }
        $table_name = $matches[1];

        return $table_name;
    }

    /**
     *   SQLļָĲѯ
     *
     * @access  public
     * @param   string    $file_path       SQLѯ
     * @param   int       $pos             ѯ
     * @return  mixed     ɹظòѯʧܷfalse
     */
    function get_spec_query_item($file_path, $pos)
    {
        $query_items = $this->parse_sql_file($file_path);

        if (empty($query_items)
                || empty($query_items[$pos]))
        {
            return false;
        }

        return $query_items[$pos];
    }

    /**
     * žMYSQL汾ݱ
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @return  boolean     ɹtrueʧܷfalse
     */
    function create_table($query_item)
    {
        /* ȡ崮ԼִСдƥ任зΪ̰ƥ */
        $pattern = '/^\s*(CREATE\s+TABLE[^(]+\(.*\))(.*)$/is';
        if (!preg_match($pattern, $query_item, $matches))
        {
            return false;
        }
        $main = $matches[1];
        $postfix = $matches[2];

        /* ӱвұ */
        $pattern = '/.*(?:ENGINE|TYPE)\s*=\s*([a-z]+).*$/is';
        $type = preg_match($pattern, $postfix, $matches) ? $matches[1] : 'MYISAM';

        /* ӱв */
        $pattern = '/.*(AUTO_INCREMENT\s*=\s*\d+).*$/is';
        $auto_incr = preg_match($pattern, $postfix, $matches) ? $matches[1] : '';

        /* ñ */
        $postfix = $this->db->version() > '4.1' ? " ENGINE=$type DEFAULT CHARACTER SET " . $this->db_charset
                                                : " TYPE=$type";
        $postfix .= ' ' . $auto_incr;

        /* ¹콨 */
        $sql = $main . $postfix;

        /* ʼ */
        if (!$this->db->query($sql, 'SILENT'))
        {
            $this->handle_error($sql);
            return false;
        }

        return true;
    }

    /**
     * ޸ݱķ㷨˼·
     * 1. Ƚֶ޸ĲCHANGE
     * 2. ȻֶƳDROP [COLUMN]
     * 3. ŽֶӲADD [COLUMN]
     * 4. ƳDROP INDEX
     * 5. ӲADD INDEX
     * 6. 
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @return  boolean     ޸ĳɹtrue򷵻false
     */
    function alter_table($query_item)
    {
        /* ȡ */
        $table_name = $this->get_table_name($query_item, 'ALTER');
        if (!$table_name)
        {
            return false;
        }

        /* ȰCHANGEȡִУٹ˵ */
        $result = $this->parse_change_query($query_item, $table_name);
        if ($result[0] && !$this->db->query($result[0], 'SILENT'))
        {
            $this->handle_error($result[0]);
            return false;
        }
        if (!$result[1])
        {
            return true;
        }

        /* DROP [COLUMN]ȡִУٹ˵ */
        $result = $this->parse_drop_column_query($result[1], $table_name);
        if ($result[0] && !$this->db->query($result[0], 'SILENT'))
        {
            $this->handle_error($result[0]);
            return false;
        }
        if (!$result[1])
        {
            return true;
        }

        /* ADD [COLUMN]ȡִУٹ˵ */
        $result = $this->parse_add_column_query($result[1], $table_name);
        if ($result[0] && !$this->db->query($result[0], 'SILENT'))
        {
            $this->handle_error($result[0]);
            return false;
        }
        if (!$result[1])
        {
            return true;
        }

        /* DROP INDEXȡִУٹ˵ */
        $result = $this->parse_drop_index_query($result[1], $table_name);
        if ($result[0] && !$this->db->query($result[0], 'SILENT'))
        {
            $this->handle_error($result[0]);
            return false;
        }
        if (!$result[1])
        {
            return true;
        }

        /* ADD INDEXȡִУٹ˵ */
        $result = $this->parse_add_index_query($result[1], $table_name);
        if ($result[0] && !$this->db->query($result[0], 'SILENT'))
        {
            $this->handle_error($result[0]);
            return false;
        }
        /* ִ޸Ĳ */
        if ($result[1] && !$this->db->query($result[1], 'SILENT'))
        {
            $this->handle_error($result[1]);
            return false;
        }

        return true;
    }

    /**
     * CHANGE
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @param   string      $table_name     
     * @return  array       һCHANGEɵ
     */
    function parse_change_query($query_item, $table_name = '')
    {
        $result = array('', $query_item);

        if (!$table_name)
        {
            $table_name = $this->get_table_name($query_item, 'ALTER');
        }

        $matches = array();
        /* 1ģʽƥold_col_name2ģʽƥcolumn_definition3ģʽƥnew_col_name */
        $pattern = '/\s*CHANGE\s*`?(\w+)`?\s*`?(\w+)`?([^,(]+\([^,]+?(?:,[^,)]+)*\)[^,]+|[^,;]+)\s*,?/i';
        if (preg_match_all($pattern, $query_item, $matches, PREG_SET_ORDER))
        {
            $fields = $this->get_fields($table_name);
            $num = count($matches);
            $sql = '';
            for ($i = 0; $i < $num; $i++)
            {
                /* дԭ */
                if (in_array($matches[$i][1], $fields))
                {
                    $sql .= $matches[$i][0];
                }
                /* д */
                elseif (in_array($matches[$i][2], $fields))
                {
                    $sql .= 'CHANGE ' . $matches[$i][2] . ' ' . $matches[$i][2] . ' ' . $matches[$i][3] . ',';
                }
                else /*  */
                {
                    $sql .= 'ADD ' . $matches[$i][2] . ' ' . $matches[$i][3] . ',';
                    $sql = preg_replace('/(\s+AUTO_INCREMENT)/i', '\1 PRIMARY KEY', $sql);
                }
            }
            $sql = 'ALTER TABLE ' . $table_name . ' ' . $sql;
            $result[0] = preg_replace('/\s*,\s*$/', '', $sql);//洢CHANGEѹĩβĶ
            $result[0] = $this->insert_charset($result[0]);//ַ
            $result[1] = preg_replace($pattern, '', $query_item);//洢
            $result[1] = $this->has_other_query($result[1]) ? $result[1]: '';
        }

        return $result;
    }

    /**
     * DROP COLUMN
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @param   string      $table_name     
     * @return  array       һDROP COLUMNɵ
     */
    function parse_drop_column_query($query_item, $table_name = '')
    {
        $result = array('', $query_item);

        if (!$table_name)
        {
            $table_name = $this->get_table_name($query_item, 'ALTER');
        }

        $matches = array();
        /* ģʽ洢 */
        $pattern = '/\s*DROP(?:\s+COLUMN)?(?!\s+(?:INDEX|PRIMARY))\s*`?(\w+)`?\s*,?/i';
        if (preg_match_all($pattern, $query_item, $matches, PREG_SET_ORDER))
        {
            $fields = $this->get_fields($table_name);
            $num = count($matches);
            $sql = '';
            for ($i = 0; $i < $num; $i++)
            {
                if (in_array($matches[$i][1], $fields))
                {
                    $sql .= 'DROP ' . $matches[$i][1] . ',';
                }
            }
            if ($sql)
            {
                $sql = 'ALTER TABLE ' . $table_name . ' ' . $sql;
                $result[0] = preg_replace('/\s*,\s*$/', '', $sql);//ĩβĶ
            }
            $result[1] = preg_replace($pattern, '', $query_item);//DROP COLUMN
            $result[1] = $this->has_other_query($result[1]) ? $result[1] : '';
        }

        return $result;
    }

    /**
     * ADD [COLUMN]
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @param   string      $table_name     
     * @return  array       һADD [COLUMN]ɵ
     */
    function parse_add_column_query($query_item, $table_name = '')
    {
        $result = array('', $query_item);

        if (!$table_name)
        {
            $table_name = $this->get_table_name($query_item, 'ALTER');
        }

        $matches = array();
        /* 1ģʽ洢ж壬2ģʽ洢 */
        $pattern = '/\s*ADD(?:\s+COLUMN)?(?!\s+(?:INDEX|UNIQUE|PRIMARY))\s*(`?(\w+)`?(?:[^,(]+\([^,]+?(?:,[^,)]+)*\)[^,]+|[^,;]+))\s*,?/i';
        if (preg_match_all($pattern, $query_item, $matches, PREG_SET_ORDER))
        {
            $fields = $this->get_fields($table_name);
            $mysql_ver = $this->db->version();
            $num = count($matches);
            $sql = '';
            for ($i = 0; $i < $num; $i++)
            {
                if (in_array($matches[$i][2], $fields))
                {
                    /* ΪͰ汾MYSQLѷǷؼֹ˵ */
                    if  ($mysql_ver < '4.0.1' )
                    {
                        $matches[$i][1] = preg_replace('/\s*(?:AFTER|FIRST)\s*.*$/i', '', $matches[$i][1]);
                    }
                    $sql .= 'CHANGE ' . $matches[$i][2] . ' ' . $matches[$i][1] . ',';
                }
                else
                {
                    $sql .= 'ADD ' . $matches[$i][1] . ',';
                }
            }
            $sql = 'ALTER TABLE ' . $table_name . ' ' . $sql;
            $result[0] = preg_replace('/\s*,\s*$/', '', $sql);//ĩβĶ
            $result[0] = $this->insert_charset($result[0]);//ַ
            $result[1] = preg_replace($pattern, '', $query_item);//ADD COLUMN
            $result[1] = $this->has_other_query($result[1]) ? $result[1] : '';
        }

        return $result;
    }

    /**
     * DROP INDEX
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @param   string      $table_name     
     * @return  array       һDROP INDEXɵ
     */
    function parse_drop_index_query($query_item, $table_name = '')
    {
        $result = array('', $query_item);

        if (!$table_name)
        {
            $table_name = $this->get_table_name($query_item, 'ALTER');
        }

        /* ģʽ洢 */
        $pattern = '/\s*DROP\s+(?:PRIMARY\s+KEY|INDEX\s*`?(\w+)`?)\s*,?/i';
        if (preg_match_all($pattern, $query_item, $matches, PREG_SET_ORDER))
        {
            $indexes = $this->get_indexes($table_name);
            $num = count($matches);
            $sql = '';
            for ($i = 0; $i < $num; $i++)
            {
                /* ģʽΪգɾ */
                if (empty($matches[$i][1]))
                {
                    $sql .= 'DROP PRIMARY KEY,';
                }
                /* ɾ */
                elseif (in_array($matches[$i][1], $indexes))
                {
                    $sql .= 'DROP INDEX ' . $matches[$i][1] . ',';
                }
            }
            if ($sql)
            {
                $sql = 'ALTER TABLE ' . $table_name . ' ' . $sql;
                $result[0] = preg_replace('/\s*,\s*$/', '', $sql);//洢DROP INDEXѹĩβĶ
            }
            $result[1] = preg_replace($pattern, '', $query_item);//洢
            $result[1] = $this->has_other_query($result[1]) ? $result[1] : '';
        }

        return $result;
    }

    /**
     * ADD INDEX
     *
     * @access  public
     * @param   string      $query_item     SQLѯ
     * @param   string      $table_name     
     * @return  array       һADD INDEXɵ
     */
    function parse_add_index_query($query_item, $table_name = '')
    {
        $result = array('', $query_item);

        if (!$table_name)
        {
            $table_name = $this->get_table_name($query_item, 'ALTER');
        }

        /* 1ģʽ洢壬2ģʽ洢"PRIMARY KEY"3ģʽ洢4ģʽ洢 */
        $pattern = '/\s*ADD\s+((?:INDEX|UNIQUE|(PRIMARY\s+KEY))\s*(?:`?(\w+)`?)?\s*\(\s*`?(\w+)`?\s*(?:,[^,)]+)*\))\s*,?/i';
        if (preg_match_all($pattern, $query_item, $matches, PREG_SET_ORDER))
        {
            $indexes = $this->get_indexes($table_name);
            $num = count($matches);
            $sql = '';
            for ($i = 0; $i < $num; $i++)
            {
                $index = !empty($matches[$i][3]) ? $matches[$i][3] : $matches[$i][4];
                if (!empty($matches[$i][2]) && in_array('PRIMARY', $indexes))
                {
                    $sql .= 'DROP PRIMARY KEY,';
                }
                elseif (in_array($index, $indexes))
                {
                    $sql .= 'DROP INDEX ' . $index . ',';
                }
                $sql .= 'ADD ' . $matches[$i][1] . ',';
            }
            $sql = 'ALTER TABLE ' . $table_name . ' ' . $sql;
            $result[0] = preg_replace('/\s*,\s*$/', '', $sql);//洢ADD INDEXѹĩβĶ
            $result[1] = preg_replace($pattern, '', $query_item);//洢Ĳ
            $result[1] = $this->has_other_query($result[1]) ? $result[1] : '';
        }

        return $result;
    }

    /**
     * ȡеindexes
     *
     * @access  public
     * @param   string      $table_name      ݱ
     * @return  array
     */
    function get_indexes($table_name)
    {
        $indexes = array();

        $result = $this->db->query("SHOW INDEX FROM $table_name", 'SILENT');

        if ($result)
        {
            while ($row = $this->db->fetchRow($result))
            {
                $indexes[] = $row['Key_name'];
            }
        }

        return $indexes;
    }

    /**
     * ȡеfields
     *
     * @access  public
     * @param   string      $table_name      ݱ
     * @return  array
     */
    function get_fields($table_name)
    {
        $fields = array();

        $result = $this->db->query("SHOW FIELDS FROM $table_name", 'SILENT');

        if ($result)
        {
            while ($row = $this->db->fetchRow($result))
            {
                $fields[] = $row['Field'];
            }
        }

        return $fields;
    }

    /**
     * жǷĲѯ
     *
     * @access  private
     * @param   string      $sql_string     SQLѯ
     * @return  boolean     зtrue򷵻false
     */
    function has_other_query($sql_string)
    {
        return preg_match('/^\s*ALTER\s+TABLE\s*`\w+`\s*\w+/i', $sql_string);
    }

    /**
     * ڲѯмַ
     *
     * @access  private
     * @param  string      $sql_string     SQLѯ
     * @return  string     ַõSQLѯ
     */
    function insert_charset($sql_string)
    {
        if ($this->db->version() > '4.1')
        {
            $sql_string = preg_replace('/(TEXT|CHAR\(.*?\)|VARCHAR\(.*?\))\s+/i',
                    '\1 CHARACTER SET ' . $this->db_charset . ' ',
                    $sql_string);
        }

        return $sql_string;
    }

    /**
     * ݿ
     *
     * @access  private
     * @param   string      $query_item     SQLѯ
     * @return  boolean     ɹtrueʧܷfalse
     */
    function do_other($query_item)
    {
        if (!$this->db->query($query_item, 'SILENT'))
        {
            $this->handle_error($query_item);
            return false;
        }

        return true;
    }

    /**
     * Ϣ
     *
     * @access  private
     * @param   string      $query_item     SQLѯ
     * @return  boolean     ɹtrueʧܷfalse
     */
    function handle_error($query_item)
    {
        $mysql_error = 'ERROR NO: ' . $this->db->errno()
                    . "\r\nERROR MSG: " . $this->db->error();

        $error_str = "SQL Error:\r\n " . $mysql_error
                . "\r\n\r\n"
                . "Query String:\r\n ". $query_item
                . "\r\n\r\n"
                . "File Path:\r\n ". $this->current_file
                . "\r\n\r\n\r\n\r\n";

        /* һЩ */
        if (!in_array($this->db->errno(), $this->ignored_errors))
        {
            $this->error = $error_str;
        }

        if ($this->log_path)
        {
            $f = @fopen($this->log_path, 'ab+');
            if (!$f)
            {
                return false;
            }
            if (!@fwrite($f, $error_str))
            {
                return false;
            }
        }

        return true;
    }
}

?>