<?php

/**
 * ECSHOP ģ ֮ ģͣ⣩
 * ============================================================================
 * Ȩ 2005-2008 ϺƼ޹˾Ȩ
 * վַ: http://www.ecshop.com
 * ----------------------------------------------------------------------------
 * ⲻһֻڲҵĿĵǰ¶Գ޸ĺ
 * ʹãԳκʽκĿĵٷ
 * ============================================================================
 * $Author: testyang $
 * $Id: cls_sms.php 15013 2008-10-23 09:31:42Z testyang $
 */

if (!defined('IN_ECS'))
{
    die('Hacking attempt');
}

require_once(ROOT_PATH . 'includes/cls_transport.php');

/* ģ */
class sms
{
    /**
     * ṩԶ̷URL
     *
     * @access  private
     * @var     array       $api_urls
     */
    var $api_urls   = array('register'          =>      'http://sms.ecshop.com/register.php',
                            'auth'              =>      'http://sms.ecshop.com/user_auth.php',
                            'send'              =>      'http://sms.ecshop.com/send_sms.php',
                            'charge'            =>      'http://sms.ecshop.com/charge.php?act=charge_form',
                            'balance'           =>      'http://sms.ecshop.com/get_balance.php',
                            'send_history'      =>      'http://sms.ecshop.com/send_history.php',
                            'charge_history'    =>      'http://sms.ecshop.com/charge_history.php');
    /**
     * MYSQL
     *
     * @access  private
     * @var     object      $db
     */
    var $db         = null;

    /**
     * ECS
     *
     * @access  private
     * @var     object      $ecs
     */
    var $ecs        = null;

    /**
     * transport
     *
     * @access  private
     * @var     object      $t
     */
    var $t          = null;

    /**
     * ųִйеĴϢһôǣֶ֧ԡ
     * ִصĲʱerror_noֵı䣬ܱΪջ0.
     * Ϊջ0ʾɹ0ֱʾʧܣִš
     *
     * @access  public
     * @var     array       $errors
     */
    var $errors  = array('api_errors'       => array('error_no' => -1, 'error_msg' => ''),
                         'server_errors'    => array('error_no' => -1, 'error_msg' => ''));

    /**
     * 캯
     *
     * @access  public
     * @return  void
     */
    function __construct()
    {
        $this->sms();
    }

    /**
     * 캯
     *
     * @access  public
     * @return  void
     */
    function sms()
    {
        /* Ҫinit.phpһǴڵģֱӸֵ */
        $this->db = $GLOBALS['db'];
        $this->ecs = $GLOBALS['ecs'];

        /* ˴òҪ$GLOBALSãֹ */
        $this->t = new transport(-1, -1, -1, false);
    }

    /**
     * Ƿעöŷ
     *
     * @access  public
     * @return  boolean     עöŷ񷵻true򷵻false
     */
    function has_registered()
    {
        $sql = 'SELECT `value`
                FROM ' . $this->ecs->table('shop_config') . "
                WHERE `code` = 'sms_user_name'";
        $result = $this->db->getOne($sql);

        if (empty($result))
        {
            return false;
        }

        return true;
    }

    /**
     * ָURL
     *
     * @access  public
     * @param   string      $key        URL֣ļ
     * @return  string or boolean       βָļӦURLֵھͷظURL򷵻false
     */
    function get_url($key)
    {
        $url = $this->api_urls[$key];

        if (empty($url))
        {
            return false;
        }

        return $url;
    }

    /**
     * öطϢ
     *
     * @access  public
     * @return  1-dimensional-array or boolean      ɹضطϢ򷵻false
     */
    function get_my_info()
    {
        $sql = 'SELECT `code`, `value`
                FROM ' . $this->ecs->table('shop_config') . "
                WHERE `code` LIKE '%sms\_%'";
        $result = $this->db->query($sql);

        $retval = array();
        if (!empty($result))
        {
            while ($temp_arr = $this->db->fetchRow($result))
            {
                $retval[$temp_arr['code']] = $temp_arr['value'];
            }

            return $retval;
        }

        return false;
    }

    /**
     * õǰڻỰ״̬ĹԱ
     *
     * @access  private
     * @return  string or boolean       ɹعԱ䣬򷵻false
     */
    function get_admin_email()
    {
        $sql = 'SELECT `email` FROM ' . $this->ecs->table('admin_user') . " WHERE `user_id` = '" . $_SESSION['admin_id'] . "'";
         $email = $this->db->getOne($sql);

         if (empty($email))
         {
            return false;
         }

         return $email;
    }

    /**
     * ȡԱ估
     *
     * @access  public
     * @return  void
     */
    function get_site_info()
    {
        /* õǰڻỰ״̬ĹԱ */
        $email = $this->get_admin_email();
        $email = $email ? $email : '';
        /* õǰ */
        $domain = $this->ecs->get_domain();
        $domain = $domain ? $domain : '';

        /* smartyģ */
        $sms_site_info['email'] = $email;
        $sms_site_info['domain'] = $domain;

        return $sms_site_info;
    }

    /**
     * עŷ
     *
     * @access  public
     * @param   string      $email          ʻϢ
     * @param   string      $password       룬δMD5
     * @param   string      $domain         
     * @param   string      $phone          ̼עʱ󶨵ֻ
     * @return  boolean                     עɹtrueʧܷfalse
     */
    function register($email, $password, $domain, $phone)
    {
        /* עϢ */
        if (!$this->check_register_info($email, $password, $domain, $phone))
        {
            $this->errors['server_errors']['error_no'] = 1;//עϢЧ

            return false;
        }

        /* ȡAPI URL */
        $url = $this->get_url('register');
        if (!$url)
        {
            $this->errors['server_errors']['error_no'] = 6;//URL

            return false;
        }

        $params = array('email' => $email,
                        'password' => $password,
                        'domain' => $domain);
        /* HTTP */
        $response = $this->t->request($url, $params);
        $http_body = $response['body'];
        if (!$response || !$http_body)
        {
            $this->errors['server_errors']['error_no'] = 7;//HTTPӦΪ

            return false;
        }

        /* APIʱ */
        $this->update_sms_last_request();

        /* XMLı */
        $xmlarr = $this->xml2array($http_body);
        if (empty($xmlarr))
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        $elems = &$xmlarr[0]['elements'];
        $count = count($elems);//dataûԪأ$count0
        if ($count === 0)
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        /* ȡϢ */
        $result = array();
        for ($i = 0; $i < $count; $i++)
        {
            $node_name = trim($elems[$i]['name']);
            switch ($node_name)
            {
                case 'user_name' :
                    $result['user_name'] = $elems[$i]['text'];
                    break;
                case 'password' :
                    $result['password'] = $elems[$i]['text'];
                    break;
                case 'auth_str' :
                    $result['auth_str'] = @$elems[$i]['text'];
                    break;
                case 'sms_num' :
                    $result['sms_num'] = @$elems[$i]['text'];
                    break;
                case 'error' :
                    $this->errors['api_errors']['error_no'] = @$elems[$i]['elements'][0]['text'];
                    break;
                default :
                    $this->errors['server_errors']['error_no'] = 9;//ЧĽڵ

                    return false;
            }
        }

        /* API */
        if (intval($this->errors['api_errors']['error_no']) !== 0)
        {
            return false;
        }

        $my_info = array('sms_user_name' => $result['user_name'],
                        'sms_password' => $result['password'],
                        'sms_auth_str' => $result['auth_str'],
                        'sms_domain' => $domain,
                        'sms_count' => 0,
                        'sms_total_money' => 0,
                        'sms_balance' => 0,
                        'sms_last_request' => gmtime());

        /* 洢طϢ */
        if (!$this->store_my_info($my_info))
        {
            $this->errors['server_errors']['error_no'] = 10;//洢ʧ

            return false;
        }

        return true;
    }

    /**
     * ´洢طϢ
     *
     * @access  public
     * @param   string      $username       û
     * @param   string      $password       룬ѾMD5
     * @return  boolean                     ´洢ɹtrueʧܷfalse
     */
    function restore($username,  $password)
    {
        /* ÷ʱûϢĺϷ */
        if (!$this->check_enable_info($username, $password))
        {
            $this->errors['server_errors']['error_no'] = 2;//ϢЧ

            return false;
        }

        /* ȡAPI URL */
        $url = $this->get_url('auth');
        if (!$url)
        {
            $this->errors['server_errors']['error_no'] = 6;//URL

            return false;
        }

        $params = array('username' => $username,
                        'password' => $password);

        /* HTTP */
        $response = $this->t->request($url, $params);
        $http_body = $response['body'];
        if (!$response || !$http_body)
        {
            $this->errors['server_errors']['error_no'] = 7;//HTTPӦΪ

            return false;
        }

        /* ʱ */
        $this->update_sms_last_request();

        /* XMLı */
        $xmlarr = $this->xml2array($http_body);
        if (empty($xmlarr))
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        $elems = &$xmlarr[0]['elements'];
        $count = count($elems);
        if ($count === 0)
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        /* ȡϢ */
        $result = array();
        for ($i = 0; $i < $count; $i++)
        {
            $node_name = trim($elems[$i]['name']);
            switch ($node_name)
            {
                case 'user_name' :
                    $result['user_name'] = $elems[$i]['text'];
                    break;
                case 'password' :
                    $result['password'] = $elems[$i]['text'];
                    break;
                case 'auth_str' :
                    $result['auth_str'] = @$elems[$i]['text'];
                    break;
                case 'domain' :
                    $result['domain'] = @$elems[$i]['text'];
                    break;
                case 'count' :
                    $result['count'] = empty($elems[$i]['text']) ? 0 : $elems[$i]['text'];
                    break;
                case 'total_money' :
                    $result['total_money'] = empty($elems[$i]['text']) ? 0 : $elems[$i]['text'];
                    break;
                case 'balance' :
                    $result['balance'] = empty($elems[$i]['text']) ? 0 : $elems[$i]['text'];
                    break;
                case 'error' :
                    $this->errors['api_errors']['error_no'] = @$elems[$i]['elements'][0]['text'];
                    break;
                default :
                    $this->errors['server_errors']['error_no'] = 9;//ЧĽڵ

                    return false;
            }
        }

        /* API */
        if (intval($this->errors['api_errors']['error_no']) !== 0)
        {
            return false;
        }

        $my_info = array('sms_user_name' => $result['user_name'],
                    'sms_password' => $result['password'],
                    'sms_auth_str' => $result['auth_str'],
                    'sms_domain' => $result['domain'],
                    'sms_count' => $result['count'],
                    'sms_total_money' => $result['total_money'],
                    'sms_balance' => $result['balance'],
                    'sms_last_request' => gmtime());

        /* 洢طϢ */
        if (!$this->store_my_info($my_info))
        {
            $this->errors['server_errors']['error_no'] = 10;//洢ʧ

            return false;
        }

        return true;
    }

    /**
     * طϢ
     *
     * @access  public
     * @return  boolean     ɹtrueʧܷfalse
     */
    function clear_my_info()
    {
        $my_info = array('sms_user_name' => '',
            'sms_password' => '',
            'sms_auth_str' => '',
            'sms_domain' => '',
            'sms_count' => '',
            'sms_total_money' => '',
            'sms_balance' => '',
            'sms_last_request' => '');

        return $this->store_my_info($my_info);
    }

    /**
     * ͶϢ
     *
     * @access  public
     * @param   string  $phone          Ҫ͵Щֻ룬ðǶŸ
     * @param   string  $msg            ͵Ϣ
     * @param   string  $send_date      ʱʱ
     * @return  boolean                 ͳɹtrueʧܷfalse
     */
    function send($phone, $msg, $send_date)
    {
        /* 鷢ϢĺϷ */
        if (!$this->check_send_sms($phone, $msg, $send_date))
        {
            $this->errors['server_errors']['error_no'] = 3;//͵Ϣ

            return false;
        }

        /* ȡ֤Ϣ */
        $login_info = $this->get_login_info();
        if (!$login_info)
        {
            $this->errors['server_errors']['error_no'] = 5;//ЧϢ

            return false;
        }

        /* ȡAPI URL */
        $url = $this->get_url('send');
        if (!$url)
        {
            $this->errors['server_errors']['error_no'] = 6;//URL

            return false;
        }

        $params = array('login_info' => $login_info,
                        'msg' => $msg,
                        'phone' => $phone,
                        'send_date' => $send_date);

        /* HTTP */
        $response = $this->t->request($url, $params);
        $http_body = $response['body'];
        if (!$response || !$http_body)
        {
            $this->errors['server_errors']['error_no'] = 7;//HTTPӦΪ

            return false;
        }

        /* APIʱ */
        $this->update_sms_last_request();

        /* XMLı */
        $xmlarr = $this->xml2array($http_body);
        if (empty($xmlarr))
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        $elems = &$xmlarr[0]['elements'][1]['elements'];
        $this->errors['api_errors']['error_no'] = @$elems[0]['text'];

        /* API */
        if (intval($this->errors['api_errors']['error_no']) !== 0)
        {
            return false;
        }

        return true;
    }

    /**
     * ȡXMLʽϢʷ¼
     *
     * @access  public
     * @param   string  $start_date     ʼ
     * @param   string  $end_date       
     * @param   string  $page_size      ÿҳʾ¼ĬΪ20
     * @param   string  $page           ʾҳĬΪ1ҳ
     * @return  string or boolean       ѯɹXMLʽıʧܷfalse
     */
    function get_send_history_by_xml($start_date, $end_date, $page_size = 20, $page = 1)
    {
        /* ѯ */
        if (!$this->check_history_query($start_date, $end_date, $page_size, $page))
        {
            $this->errors['server_errors']['error_no'] = 4;//дĲѯϢ

            return false;
        }

        /* ȡ֤Ϣ */
        $login_info = $this->get_login_info();
        if (!$login_info)
        {
            $this->errors['server_errors']['error_no'] = 5;//ЧϢ

            return false;
        }

        /* ȡAPI URL */
        $url = $this->get_url('send_history');
        if (!$url)
        {
            $this->errors['server_errors']['error_no'] = 6;//URL

            return false;
        }

        $params = array('login_info' => $login_info,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'page_size' => $page_size,
                        'page' => $page);

        /* HTTP */
        $response = $this->t->request($url, $params);
        $http_body = $response['body'];
        if (!$response || !$http_body)
        {
            $this->errors['server_errors']['error_no'] = 7;//HTTPӦΪ

            return false;
        }

        /* APIʱ */
        $this->update_sms_last_request();

        return $http_body;//xmlı
    }

    /**
     * ȡϢʷ¼
     *
     * @access  public
     * @param   string  $start_date                 ʼ
     * @param   string  $end_date                   
     * @param   string  $page_size                  ÿҳʾ¼ĬΪ20
     * @param   string  $page                       ʾҳĬΪ1ҳ
     * @return  1-dimensional-array or boolean      ѯɹʷ¼飬ʧܷfalse
     */
    function get_send_history($start_date, $end_date, $page_size = 20, $page = 1)
    {
        /* ȡXMLı */
        $xml = $this->get_send_history_by_xml($start_date, $end_date, $page_size, $page);
        if (!$xml)
        {
            return false;
        }

        /* XMLı */
        $xmlarr = $this->xml2array($xml);
        if (empty($xmlarr))
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        $result = array();

        $attrs = &$xmlarr[0]['attributes'];
        $result['count'] = $attrs['count'];

        $elems = &$xmlarr[0]['elements'];
        $count = count($elems);
        if ($count === 0)
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        /* ȡϢ */
        $send_num = $count - 1;
        for ($i = 0; $i < $send_num; $i++)
        {
            if (empty($elems[$i]['attributes']))//Ϊ
            {
                continue;
            }
            $result['send'][$i]['phone'] = $elems[$i]['attributes']['phone'];
            $result['send'][$i]['content'] = $elems[$i]['attributes']['content'];
            $result['send'][$i]['charge_num'] = $elems[$i]['attributes']['charge_num'];
            $result['send'][$i]['send_date'] = $elems[$i]['attributes']['send_date'];
            $result['send'][$i]['send_status'] = $elems[$i]['attributes']['send_status'];
        }
        $this->errors['api_errors']['error_no'] = @$elems[$send_num]['elements'][0]['text'];

        /* API */
        if (intval($this->errors['api_errors']['error_no']) !== 0)
        {
            return false;
        }

        return $result;
    }

    /**
     * ȡXMLʽĳֵʷ¼
     *
     * @access  public
     * @param   string  $start_date     ʼ
     * @param   string  $end_date       
     * @param   string  $page_size      ÿҳʾ¼ĬΪ20
     * @param   string  $page           ʾҳĬΪ1ҳ
     * @return  string or boolean       ѯɹXMLʽıʧܷfalse
     */
    function get_charge_history_by_xml($start_date, $end_date, $page_size = 20, $page = 1)
    {
        /* ѯĺϷ */
        if (!$this->check_history_query($start_date, $end_date, $page_size, $page))
        {
            $this->errors['server_errors']['error_no'] = 4;//дĲѯϢ

            return false;
        }

        /* ȡ֤Ϣ */
        $login_info = $this->get_login_info();
        if (!$login_info)
        {
            $this->errors['server_errors']['error_no'] = 5;//ЧϢ

            return false;
        }

        $params = array('login_info' => $login_info,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'page_size' => $page_size,
                        'page' => $page);

        /* ȡAPI URL */
        $url = $this->get_url('charge_history');
        if (!$url)
        {
            $this->errors['server_errors']['error_no'] = 6;//URL

            return false;
        }

        /* HTTP */
        $response = $this->t->request($url, $params);
        $http_body = $response['body'];
        if (!$response || !$http_body)
        {
            $this->errors['server_errors']['error_no'] = 7;//HTTPӦΪ

            return false;
        }

        /* APIʱ */
        $this->update_sms_last_request();

        return $http_body;//xmlı
    }

    /**
     * ȡĳֵʷ¼
     *
     * @access  public
     * @param   string  $start_date                 ʼ
     * @param   string  $end_date                   
     * @param   string  $page_size                  ÿҳʾ¼ĬΪ20
     * @param   string  $page                       ʾҳĬΪ1ҳ
     * @return  1-dimensional-array or boolean      ѯɹʷ¼飬ʧܷfalse
     */
    function get_charge_history($start_date, $end_date, $page_size, $page)
    {
        /* ȡXMLı */
        $xml = $this->get_charge_history_by_xml($start_date, $end_date, $page_size, $page);
        if (!$xml)
        {
            return false;
        }

        /* XMLı */
        $xmlarr = $this->xml2array($xml);
        if (empty($xmlarr))
        {
            $this->errors['server_errors']['error_no'] = 8;//ЧXMLļ

            return false;
        }

        $result = array();

        $attrs = &$xmlarr[0]['attributes'];
        $result['count'] = $attrs['count'];

        $elems = &$xmlarr[0]['elements'];
        $count = count($elems);
        $charge_num = $count - 1;//ǰN-1Ԫشųֵ¼һԪشŴϢ
        /* ȡϢ */
        for ($i = 0; $i < $charge_num; $i++)
        {
            if (empty($elems[$i]['attributes']))
            {
                continue;
            }
            $result['charge'][$i]['order_id'] = $elems[$i]['attributes']['order_id'];
            $result['charge'][$i]['money'] = $elems[$i]['attributes']['money'];
            $result['charge'][$i]['log_date'] = $elems[$i]['attributes']['log_date'];
        }

        $this->errors['api_errors']['error_no'] = @$elems[$charge_num]['elements'][0]['text'];

        if (intval($this->errors['api_errors']['error_no']) !== 0)
        {
            return false;
        }

        return $result;
    }

    /**
     * ûעϢǷϷ
     *
     * @access  private
     * @param   string      $email          䣬䵱ûû
     * @param   string      $password       
     * @param   string      $domain         
     * @param   string      $phone          ̼Ұ󶨵ֻ
     * @return  boolean                     עϢʽϷtrue򷵻false
     */
    function check_register_info($email, $password, $domain, $phone)
    {
        /*
         * ԶAPIӦĹ˴һֵΪգAPIֱ˳
         * ⲻǽһ
         * ˴˴򵥵жֵǷΪա
         * ·漰ԶAPIӦʩĴ룬һֻм򵥵пռ⡣
         */
        if (empty($email) || empty($password) || empty($domain))
        {
            return false;
        }

        if (!empty($phone))
        {
            if (preg_match('/^\d+$/', $phone))
            {
                $sql = 'UPDATE ' . $this->ecs->table('shop_config') . "
                        SET `value` = '$phone'
                        WHERE `code` =  'sms_shop_mobile'";
                $this->db->query($sql);
            }
            else
            {
                return false;
            }
        }

        return true;
    }

    /**
     * 洢طϢ
     *
     * @access  private
     * @param   1-dimensional-array     $my_info    طϢ
     * @return  boolean                             洢ɹtrueʧܷfalse
     */
    function store_my_info($my_info)
    {
        /* β飬false */
        if (!is_array($my_info))
        {
            return false;
        }

        foreach ($my_info AS $key => $value)
        {
            $sql = 'UPDATE ' . $this->ecs->table('shop_config') . " SET `value` = '$value' WHERE `code` = '$key'";
            $result = $this->db->query($sql);

            if (empty($result))
            {
                return false;
            }
        }

        return true;
    }

    /**
     * ݿе¼
     *
     * @access  private
     * @return  boolean             ³ɹtrueʧܷfalse
     */
    function update_sms_last_request()
    {
        $sql = 'UPDATE ' . $this->ecs->table('shop_config') . " SET `value` = '" . gmtime() . "' WHERE `code` = 'sms_last_request'";
        $result = $this->db->query($sql);

        if (empty($result))
        {
            return false;
        }

        return true;
    }

    /**
     * öŷҪϢ
     *
     * @access  private
     * @param   string      $email          
     * @param   string      $password       
     * @return  boolean                     ϢʽϷͷtrue򷵻false
     */
    function check_enable_info($email, $password)
    {
        if (empty($email) || empty($password))
        {
            return false;
        }

        return true;
    }

    /**
     * ⷢ͵ĶϢʽǷϷ
     *
     * @access  private
     * @param   string      $phone          ͵Щ绰
     * @param   string      $msg            Ϣ
     * @param   string      $send_date      ʱʱ
     * @return  boolean                     ϢʽϷtrue򷵻false
     */
    function check_send_sms($phone, $msg, $send_date)
    {
        if (empty($phone) || empty($msg))
        {
            return false;
        }

        if (!empty($send_date) && $this->check_date_format($send_date))
        {
            return false;
        }

        return true;
    }

    /**
     * ֤ݵϢ
     *
     * @access  private
     * @return  string or boolean   ɹڵ¼ŷʺϢʧܷfalse
     */
    function get_login_info()
    {
        $sql = 'SELECT `code`, `value` FROM ' . $this->ecs->table('shop_config') . " WHERE `code` = 'sms_user_name' OR `code` = 'sms_password'";
        $result = $this->db->query($sql);

        $retval = array();
        if (!empty($result))
        {
            while ($temp_arr = $this->db->fetchRow($result))
            {
                $retval[$temp_arr['code']] = $temp_arr['value'];
            }

            return base64_encode($retval['sms_user_name'] . "\t" . $retval['sms_password']);
        }

        return false;
    }

    /**
     * ڲѯʷ¼ĸʽǷϷ
     *
     * @access  private
     * @param   string      $start_date         ʼڣΪ
     * @param   string      $end_date           ڣΪ
     * @param   string      $page_size          ÿҳʾĬΪ20
     * @param   string      $page               ҳĬΪ1
     * @return  boolean                         ѯʽϷͷtrue򷵻false
     */
    function check_history_query($start_date, $end_date, $page_size =  20, $page = 1)
    {
        /* ڸʽ */
        if (!empty($start_date) && !$this->check_date_format($start_date))
        {
            return false;
        }
        if (!empty($end_date) && !$this->check_date_format($end_date))
        {
            return false;
        }

        /* ֲ */
        if (!is_numeric($page_size) || !is_numeric($page))
        {
            return false;
        }

        return true;
    }

    /**
     * ڵĸʽǷԶAPIҪĸʽ
     *
     * @access  private
     * @param   1-dimensional-array or string       $date           
     * @return  boolean                                             ʽϷͷtrue򷵻false
     */
    function check_date_format($date)
    {
        $pattern = '/\d{4}-\d{2}-\d{2}/';
        if (is_array($date))
        {
            foreach ($date AS $value)
            {
                if (!preg_match($pattern, $value))
                {
                    return false;
                }
            }
        }
        elseif (!preg_match($pattern, $date))
        {
            return false;
        }

        return true;
    }

    /**
     * XMLתPHP
     *
     * @access  private
     * @param   string      $xml    XML
     * @author  www.google.com
     *
     * @return  array       PHP
     */
    function xml2array($xml)
    {
        $xmlary = array();

        $reels = '/<(\w+)\s*([^\/>]*)\s*(?:\/>|>(.*)<\/\s*\1\s*>)/s';
        $reattrs = '/(\w+)=(?:"|\')([^"\']*)(:?"|\')/';

        preg_match_all($reels, $xml, $elements);

        foreach ($elements[1] AS $ie => $xx)
        {
            $xmlary[$ie]['name'] = $elements[1][$ie];

            if ($attributes = trim($elements[2][$ie]))
            {
                preg_match_all($reattrs, $attributes, $att);
                foreach ($att[1] AS $ia => $xx)
                {
                    $xmlary[$ie]['attributes'][$att[1][$ia]] = $att[2][$ia];
                }
            }

            $cdend = strpos($elements[3][$ie], '<');
            if ($cdend > 0)
            {
                $xmlary[$ie]['text'] = substr($elements[3][$ie], 0, $cdend - 1);
            }

            if (preg_match($reels, $elements[3][$ie]))
            {
                $xmlary[$ie]['elements'] = $this->xml2array($elements[3][$ie]);
            }
            elseif ($elements[3][$ie])
            {
                $xmlary[$ie]['text'] = $elements[3][$ie];
            }
        }

        //Ҳκƥ䣬򷵻ؿ
        return $xmlary;
    }
}

?>